' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.IO

Partial Class InsertUpdateFaq
  Inherits System.Web.UI.Page

  Private _id As Integer = -1

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Request.QueryString.Get("id") IsNot Nothing Then
      _id = Convert.ToInt32(Request.QueryString.Get("id"))
      PageTitle.InnerText = "Edytuj pytanie"
    Else
      PageTitle.InnerText = "Utwrz nowe pytanie"
    End If
    If Not Page.IsPostBack Then
      LoadData()
    End If
  End Sub

  Private Sub LoadData()
    Dim myFaq As Faq = Faq.Get(_id)
    If myFaq IsNot Nothing Then
      txtQuestionShort.Text = myFaq.QuestionShort
      txtQuestionLong.Value = myFaq.QuestionLong
      txtAnswer.Value = myFaq.Answer
    End If
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    ' Tu sprawd poprawno i zmie dane
    Dim questionShort As String = String.Empty
    If txtQuestionShort.Text.Length > 100 Then
      questionShort = txtQuestionShort.Text.Substring(0, 100)
    Else
      questionShort = txtQuestionShort.Text
    End If

    If Page.IsValid Then

      Dim myFaq As Faq
      If _id > -1 Then
        myFaq = Faq.Get(_id)
      Else
        myFaq = New Faq()
      End If

      myFaq.QuestionShort = txtQuestionShort.Text
      myFaq.QuestionLong = txtQuestionLong.Value
      myFaq.Answer = txtAnswer.Value

      myFaq.Save()
      Response.Redirect("Faqs.aspx")

    End If

  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Response.Redirect("Faqs.aspx")
  End Sub
End Class
